using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace SMAT_CE
{
    public partial class uc_SpeciesFrctionD : ucBase
    {
        public uc_SpeciesFrctionD()
        {
            InitializeComponent();

            #region Language added by Yangwenwei
            if (LanguageOld.CurrentLanguage() == "Ch")
            {
                //Language.GetLanguagePath();
                Dictionary<string, string> dic = new Dictionary<string, string>();
                LanguageOld.SetDicFromXml(this, dic);
                LanguageOld.ChangeLanguage(dic, this);
            }
            #endregion
        }

        private void uc_SpeciesFrctionD_Load(object sender, EventArgs e)
        {
            try
            {
                cboPM25InterpolationDaily.Items.Add("Equal Weighting of Monitors");
                cboPM25InterpolationDaily.Items.Add("Inverse Distance Weights");
                cboPM25InterpolationDaily.Items.Add("Inverse Distance Squared Weights");

                cboSO4InterpolationDaily.Items.Add("Equal Weighting of Monitors");
                cboSO4InterpolationDaily.Items.Add("Inverse Distance Weights");
                cboSO4InterpolationDaily.Items.Add("Inverse Distance Squared Weights");

                cboNO3InterpolationDaily.Items.Add("Equal Weighting of Monitors");
                cboNO3InterpolationDaily.Items.Add("Inverse Distance Weights");
                cboNO3InterpolationDaily.Items.Add("Inverse Distance Squared Weights");

                cboECInterpolationDaily.Items.Add("Equal Weighting of Monitors");
                cboECInterpolationDaily.Items.Add("Inverse Distance Weights");
                cboECInterpolationDaily.Items.Add("Inverse Distance Squared Weights");

                cboSaltInterpolationDaily.Items.Add("Equal Weighting of Monitors");
                cboSaltInterpolationDaily.Items.Add("Inverse Distance Weights");
                cboSaltInterpolationDaily.Items.Add("Inverse Distance Squared Weights");

                cboCrastalInterpolationDaily.Items.Add("Equal Weighting of Monitors");
                cboCrastalInterpolationDaily.Items.Add("Inverse Distance Weights");
                cboCrastalInterpolationDaily.Items.Add("Inverse Distance Squared Weights");

                cboDONInterpolationDaily.Items.Add("Equal Weighting of Monitors");
                cboDONInterpolationDaily.Items.Add("Inverse Distance Weights");
                cboDONInterpolationDaily.Items.Add("Inverse Distance Squared Weights");

                cboOCInterpolationDaily.Items.Add("Equal Weighting of Monitors");
                cboOCInterpolationDaily.Items.Add("Inverse Distance Weights");
                cboOCInterpolationDaily.Items.Add("Inverse Distance Squared Weights");

                cboNH4InterpolationDaily.Items.Add("Equal Weighting of Monitors");
                cboNH4InterpolationDaily.Items.Add("Inverse Distance Weights");
                cboNH4InterpolationDaily.Items.Add("Inverse Distance Squared Weights");

                choAdvancedOptions_CheckStateChanged(sender, e);
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        private void lblImproveMonitorData_LinkClicked(object sender, LinkLabelLinkClickedEventArgs e)
        {
            try
            {
                Help.ShowHelp(this, Application.StartupPath + @"\Data\User Manual.chm", "2_2_4_species_fraction_options.htm");
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        private void lblPMMonitorData_LinkClicked(object sender, LinkLabelLinkClickedEventArgs e)
        {
            try
            {
                Help.ShowHelp(this, Application.StartupPath + @"\Data\User Manual.chm", "2_2_4_species_fraction_options.htm");
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        private void choAdvancedOptions_CheckStateChanged(object sender, EventArgs e)
        {
            try
            {
                if (choAdvancedOptions.Checked)
                {
                    this.Height = 1915;
                }
                else
                {
                   // this.Height = 731;
                    this.Height = 1237;
                }
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        private void rbtnDONValueDaily_CheckedChanged(object sender, EventArgs e)
        {
            cboDONInterpolationDaily.Enabled = true;
            nudownDONDistanceDaily.Enabled = true;
            cboNH4InterpolationDaily.Enabled = false;
            nudownNH4DistanceDaily.Enabled = false;
            nudownNH4PercDaily.Enabled = false;
        }

        private void rbtnMeasuredAmmoniumDaily_CheckedChanged(object sender, EventArgs e)
        {
            cboDONInterpolationDaily.Enabled = false;
            nudownDONDistanceDaily.Enabled = false;
            cboNH4InterpolationDaily.Enabled = true;
            nudownNH4DistanceDaily.Enabled = true;
            nudownNH4PercDaily.Enabled = true;
        }

        private void cboIMPROVEMonitorStartYearDaily_SelectionChangeCommitted(object sender, EventArgs e)
        {
            try
            {
                if (Convert.ToInt32(cboIMPROVEMonitorStartYearDaily.Text) > Convert.ToInt32(cboIMPROVEMonitorEndYearDaily.Text))
                    cboIMPROVEMonitorEndYearDaily.Text = cboIMPROVEMonitorStartYearDaily.Text;
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        private void cboIMPROVEMonitorEndYearDaily_SelectionChangeCommitted(object sender, EventArgs e)
        {
            try
            {
                if (Convert.ToInt32(cboIMPROVEMonitorStartYearDaily.Text) > Convert.ToInt32(cboIMPROVEMonitorEndYearDaily.Text))
                    cboIMPROVEMonitorStartYearDaily.Text = cboIMPROVEMonitorEndYearDaily.Text;
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        private void cboPMMonitorStartYearDaily_SelectionChangeCommitted(object sender, EventArgs e)
        {
            try
            {
                if (Convert.ToInt32(cboPMMonitorStartYearDaily.Text) > Convert.ToInt32(cboPMMonitorEndYearDaily.Text))
                    cboPMMonitorEndYearDaily.Text = cboPMMonitorStartYearDaily.Text;
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        private void cboPMMonitorEndYearDaily_SelectionChangeCommitted(object sender, EventArgs e)
        {
            try
            {
                if (Convert.ToInt32(cboPMMonitorStartYearDaily.Text) > Convert.ToInt32(cboPMMonitorEndYearDaily.Text))
                    cboPMMonitorStartYearDaily.Text = cboPMMonitorEndYearDaily.Text;
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }
    }
}
